<?php
/*--------------------------------------------------------------------------------------------------
    add_session_hash_to_counter_table.php 2022-11-23
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2022 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

/** @var DatabaseModel $this */
/** @var int $t_success */

if (!$this->columnExists('gm_counter_ip', 'session_hash')) {
    $t_success &= $this->query("ALTER TABLE `gm_counter_ip` ADD `session_hash` varchar(32) NOT NULL DEFAULT '' AFTER `gm_ip_date`;");
}

if (!$this->indexExists('gm_counter_ip', 'INDEX', ['gm_ip_value'])) {
    $t_success &= $this->set_index('gm_counter_ip', 'INDEX', ['gm_ip_value'], 'gm_ip_value');
}

if (!$this->indexExists('gm_counter_ip', 'INDEX', ['session_hash'])) {
    $t_success &= $this->set_index('gm_counter_ip', 'INDEX', ['session_hash'], 'session_hash');
}